<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class City extends CI_Controller {

	function __construct()	{
		parent::__construct();
		$this->load->model('master_model');
		//$this->lang->load('masters', '');	
		$language = $this->session->userdata('language'); 
    		if ($language=='hindi') {
      	       $this->lang->load('hindi', '');
   			}else{
      		    $this->lang->load('masters', '');
            }
//error_reporting(E_ALL);

	}

	function index()	{	
		$this->manage_city();
	}
	
	

	function list_city() {
		admin_auth();
			
		$this->page_data['page_title']="List Of Cities";
		$this->page_data['bredcrum']=array(	
										'Master'=>'#',		                           
										'City'=>'#',
										'List City'=>'#',
										);


		$condition = array();
                            
                            $condition[] = array('join',TABLE_STATE,TABLE_STATE.'.state_id ='.TABLE_CITY.'.state_id');
                           // $condition[] = array('where','users.is_active');


                            $selected_array=array(
                                'table_name'=>TABLE_CITY,
                                'table_fields'=>TABLE_CITY.'.is_active,city_id,city_name,state_name,'.TABLE_STATE.'.state_id',
                                'condition'=>$condition,
                                'order_by_field'=>'city_name',
                                'order'=>'ASC',
                                'limit'=>'',
                                'offset'=>''
                            );
 

		$city['city'] = $this->master_model->select_data($selected_array);  

		 if(!empty($city['city'])&& is_array($city['city'])){
							
				 $this->page_data['city'] =   $city['city'];
		 	

  	    }    
  	        $this->load->view('gc/city_list',$this->page_data);
	}	
	
	function view_city($city_id) {
		admin_auth();
		$id=$this->encrypt->decode($city_id);
		 $id=encrypt_decrypt_parameters($city_id,'decrypt');
			//error_reporting(E_ALL);
     
		$this->_page_data['page_title']="View City";
		$this->_page_data['bredcrum']=array(
			 							'Master'=>'#',
			 							'City'=>'#',
										'List City'=>site_url('gc/city/list_city'),
										'View city'=>'#',
										);
		$condition = array();
                            
                          $condition[] = array('join',TABLE_STATE,TABLE_STATE.'.state_id ='. TABLE_CITY.'.state_id');
                          $condition[] = array('join',TABLE_COUNTRY,TABLE_COUNTRY.'.country_id ='. TABLE_STATE.'.country_id');
                          $condition[] = array('where','city_id',$id);

                            $selected_array=array(
                                'table_name'=>TABLE_CITY,
                                'table_fields'=>TABLE_CITY.'.is_active,city_id,city_name,state_name,'.TABLE_STATE.'.state_id,'.TABLE_COUNTRY.'.country_name',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );

		$city['city'] = $this->master_model->select_data($selected_array);
		
		if(!empty($city['city'])&& is_array($city['city']))
			{
				 $this->_page_data['city'] = $city['city'];		 
  	        }
		$this->load->view('gc/city_view.php',$this->_page_data);
	}
	
	function manage_city($city_id="") {
		admin_auth();
		$id=$this->encrypt->decode($city_id);
		$id=encrypt_decrypt_parameters($city_id,'decrypt');
		$this->_page_data['ci_City_Name']=$ci_City_present=$this->lang->line('ci_City_Name', FALSE);
		$this->_page_data['st_State_Name']=$ci_City_present=$this->lang->line('st_State_Name', FALSE);
		$this->_page_data['st_country']=$ci_City_present=$this->lang->line('st_country', FALSE);
		$this->_page_data['country'] =$this->fetch_country();	
		//$this->_page_data['purpose']=$purpose;
		if ($id){
				$this->_page_data['page_title']="Edit City";
				$this->_page_data['bredcrum']=array(
										'Master'=>'#',	
										'City'=>'#',
										'List City'=>site_url(CITY.'list_city'),
										'Edit City'=>'#',
										);
				$this->_page_data['check'] ='edit';

		}else{
				$this->_page_data['page_title']="Add City";
				$this->_page_data['bredcrum']=array(
										'Master'=>'#',
										'City'=>'#',
										'Add City'=>'#',
										);
				$this->_page_data['check'] ='';
		}
		
	
         							
		if (!$id) {
            
	       $this->load->view('gc/city_manage.php',$this->_page_data);

		}else{
                     
			 $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                            $condition[] = array('join',TABLE_STATE,TABLE_CITY.'.state_id ='. TABLE_STATE.'.state_id');
                            $condition[] = array('join',TABLE_COUNTRY,TABLE_COUNTRY.'.country_id ='. TABLE_STATE.'.country_id');
                           // $condition[] = array('where','users.is_active');
                             $condition[] = array('where','city_id',$id);

                            $selected_array=array(
                                'table_name'=>TABLE_CITY,
                                'table_fields'=>TABLE_CITY.'.is_active,city_id,city_name,state_name,'.TABLE_STATE.'.state_id,'.TABLE_COUNTRY.'.country_name,'.TABLE_COUNTRY.'.country_id',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );
		$city['city'] = $this->master_model->select_data($selected_array);
		
		if(!empty($city['city'] )&& is_array($city['city']))
			{
			
				// foreach ($city['city'] as  $value1) {

				// 	$this->_page_data['city'] = $value1['city_name'];
				// 	$this->_page_data['city_id']=$value1['city_id'];
				// 	$this->_page_data['state_id']=$value1['state_id'];
				$this->_page_data['city'] = $city['city'];	
				// }
  	  			 
  	        }
		  $this->load->view('gc/city_manage.php',$this->_page_data); 
		
		}

	}
	

    function add_city(){
    	admin_auth();
    	//$id=$this->encrypt->decode($city_id);
    		//error_reporting(E_ALL);

 		$ci_City_created=$this->lang->line('ci_City_created', FALSE);
 		$ci_City_updated=$this->lang->line('ci_City_updated', FALSE);
 		$ci_City_present=$this->lang->line('ci_City_present', FALSE);

    	$id = check_injections_filter($this->input->post('hidden'));
    	$city_name = check_injections_filter($this->input->post('city_name'));
    	$s_city_name=strtolower($city_name);
    	$state_name =check_injections_filter($this->input->post('state_name'));
    	$user_id = $this->session->userdata('user_id');


    	$this->form_validation->set_rules('city_name', 'City Name', 'required');   
    	if ($this->form_validation->run() == FALSE)
        {
        	//redirect('gc/city/manage_city');
            $this->manage_city();
        }else{
       		 
      		if ($id) { 
      			$condition[] = array('where','LOWER(city_name)',$s_city_name); 
      			$condition[] = array('where','state_id',$state_name);    				         	
    	    	$condition[] = array('where_not_in','city_id',$id);
            }else{
            	$condition[] = array('where','LOWER(city_name)',$s_city_name);
            	$condition[] = array('where','state_id',$state_name);
            	           		
            }

    	    $selected_array=array(
								'table_name' =>TABLE_CITY,								
								'table_fields'=>'city_name,state_id',
								'limit'=>'',
								'offset'=>'',
								'condition'=>$condition							
					        );
    			$city['city']  = $this->master_model->select_data($selected_array);
    			// dump($this->db->last_query());
    			// exit;
               if(!empty($city['city'] ))
				{
					 $this->session->set_flashdata('message',$ci_City_present);
				     redirect('gc/city/manage_city');
  	  			 
  	        	}else{
    		       if (!$id) {     
				         
				         $city_data=array(
								'city_name' => $city_name,
								'state_id' =>$state_name,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => '',	
								'modified_on' => date("Y-m-d H:i:s")
								
					    );
				            $this->master_model->insert_record(TABLE_CITY,$city_data);
				         	$this->session->set_flashdata('message',$ci_City_created);
				         	redirect('gc/city/list_city');
				         
    	                 
    	            }else{
			
				 		$city_data=array(
								'city_name' => $city_name,
								'state_id' =>$state_name,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")
								
					    );
				 		$condition=array('city_id'=>$id);
				 		$this->master_model->update_record(TABLE_CITY,$city_data,$condition);
				 		    $this->session->set_flashdata('message',$ci_City_updated);
				 		    redirect('gc/city/list_city');
			     		
			        }
               }
        }
    }

    function fetch_country(){
    	admin_auth();
    	$condition[] = array('where','is_active','1');
    	$selected_array = array( 
			                   'table_name' =>TABLE_COUNTRY,
			                   'table_fields' =>'country_id,country_name,is_active',
			                   'condition'=>$condition,
			                   'limit'=>'',
			                   'offset'=>'',
			                   'order_by_field'=>'Asc'
		);

		return $this->master_model->select_data($selected_array);		         
    }
    function get_state()
	{
		$country_id=$this->input->post('country_id');
		$state_id=$this->input->post('state_id');
	    $salse_person_cond = array();
		$salse_person_cond[] = array('where','country_id',$country_id);
	
		$salse_person_cond[] = array('where','is_active','1');
		$select_array = array(
								'table_name'=>TABLE_STATE,
								'table_fields'=>'state_id,state_name',
								'condition'=>$salse_person_cond,
								'sort_by'=>'state_name',
								'order_by_field'=>'state_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$salse_person_data = $this->master_model->select_data($select_array);
		$output='<option value="default">Select State Name</option>';
		foreach($salse_person_data as $row)
		{
        
         	$selected='';

             if ($row['state_id']==$state_id) 

			 {

				$selected='selected="selected"';

			 }
		 		 $output .= '<option value='.$row['state_id'].' '.$selected.'>'.$row['state_name'].'</option>';
		 

		}

          echo $output;	
    }
    function disable_city($city_id){
    	//error_reporting(E_ALL);
    	admin_auth();
    	$user_id = $this->session->userdata('user_id');
    	$ci_City_disable=$this->lang->line('ci_City_disable', FALSE);
    	$id=$this->encrypt->decode($city_id);
		$id=encrypt_decrypt_parameters($city_id,'decrypt');
        $city_data=array(
								'is_active' =>'0',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => $user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('city_id'=>$id);
		$this->master_model->update_record(TABLE_CITY,$city_data,$condition);
		$this->session->set_flashdata('message',$ci_City_disable);
	    redirect('gc/city/list_city');
		
		
    }

    function enable_city($city_id){
    	admin_auth();
    	$user_id = $this->session->userdata('user_id');
    	$ci_City_enable=$this->lang->line('ci_City_enable', FALSE);
    	$id=$this->encrypt->decode($city_id);
		$id=encrypt_decrypt_parameters($city_id,'decrypt');
        $city_data=array(
								'is_active' =>'1',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('city_id'=>$id);  	
		$this->master_model->update_record(TABLE_CITY,$city_data,$condition);
		$this->session->set_flashdata('message',$ci_City_enable);
	    redirect('gc/city/list_city');
	
		
    }

}