<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Country extends CI_Controller {

	function __construct()	{
		parent::__construct();
		$this->load->model('master_model');
		$language = $this->session->userdata('language'); 
    		if ($language=='hindi') {
      	       $this->lang->load('hindi', '');
   			}else{
      		    $this->lang->load('masters', '');
            }
		//$this->lang->load('masters', '');
		//error_reporting(E_ALL);

	}

	function index()	{	
		$this->list_country();
	}
	
	

	function list_country() {
		admin_auth();
        $this->page_data['page_title']="List Country";	
  		$this->page_data['bredcrum']=array(	
  										'Master'=>'#',		                           
										'Country'=>'#',
										'List of Country'=>'#',
										);

	    $condition = array();
                          
                           
            $select_array=array(
                                'table_name'=>TABLE_COUNTRY,
                                'table_fields'=>'is_active,country_id,country_name,country_code,std_code',
                                'condition'=>$condition,
                                'order_by_field'=>'country_name,country_code',
                                'group_by_field'=>'country_name',
                                'order'=>'ASC',
                                'limit'=>'',
                                'offset'=>''
                            );
            $country['country']=$this->master_model->select_data($select_array);                          
            if(!empty($country['country'])&& is_array($country['country'])){
							
			    $this->page_data['country'] =  $country['country'];
  	         }
      
  	        $this->load->view('gc/list_country',$this->page_data);
	}

	function view_country($country_id="") {		
     admin_auth();
     $id=$this->encrypt->decode($country_id);
	 $id=encrypt_decrypt_parameters($country_id,'decrypt');
		$this->data['page_title']="View Country";
		$this->data['bredcrum']=array(
			 							'Master'=>'#',
			 							'Country'=>'#',
										'List of country'=>site_url('gc/country/list_country'),
										'View Country'=>'#',
										);

		  $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                            
                            $condition[] = array('where','country_id',$id);

                            $selected_array=array(
                                'table_name'=>TABLE_COUNTRY,
                                'table_fields'=>'is_active,country_id,country_name,country_code,std_code',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );

		$country['country'] = $this->master_model->select_data($selected_array);
		if(!empty($country['country'] )&& is_array($country['country']))
			{
				 $this->data['country'] = $country['country'];
				 
  	  			 
  	        }
		$this->load->view('gc/view_country.php',$this->data);

	}



	function manage_country($country_id="") {
		admin_auth();
		$id=$this->encrypt->decode($country_id);
		$id=encrypt_decrypt_parameters($country_id,'decrypt');
		$this->_page_data['currency'] = $this->fetch_currency();

		$cou_Country_Name = $this->lang->line('cou_Country_Name', FALSE);
		$cou_Country_Code = $this->lang->line('cou_Country_Code', FALSE);

		$this->_page_data['cou_Country_Name'] = $cou_Country_Name;
		$this->_page_data['cou_Country_Code'] = $cou_Country_Code;
		$this->_page_data['cou_STD_Code'] = $this->lang->line('cou_STD_Code', FALSE);
		if ($id) {
		 $this->_page_data['page_title']="Edit Country";
		 $this->_page_data['bredcrum']=array(
										'Master'=>'#',
										'Country'=>'#',
										'List Country'=>site_url(COUNTRY.'list_country'),
										'Edit Country'=>'#',
										);
		}else{
			$this->_page_data['page_title']="Add Country";
			$this->_page_data['bredcrum']=array(
										'Master'=>'#',
										'Country'=>'#',
										'Add Country'=>'#',
										);
		} 

		
	
		if (!$id) {
            
	       $this->load->view('gc/add_country.php',$this->_page_data);

		}else{
                     
				 $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                         
                            $condition[] = array('where','country_id',$id);

                            $selected_array=array(
                                'table_name'=>TABLE_COUNTRY,
                                'table_fields'=>'is_active,country_id,country_name,country_code,std_code',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );
		$country['country'] = $this->master_model->select_data($selected_array);
		
		if(!empty($country['country'] )&& is_array($country['country']))
			{
				  $this->_page_data['country'] = $country['country'] ;
				//  foreach ($country['country'] as  $value) {

				// 	$this->_page_data['country_name'] = $value['country_name'];
				// 	$this->_page_data['country_code']=$value['country_code'];
				// 	$this->_page_data['currency_id']=$value['currency_id'];
				// 	$this->_page_data['country_id']=$value['country_id'];
				// }
				 
  	  			 
  	        }
		  $this->load->view('gc/add_country.php',$this->_page_data); 
		
		}
	 }
	function add_country(){
    	   	  admin_auth();

		$cou_Country_created=$this->lang->line('cou_Country_created', FALSE);
 		$cou_Country_updated=$this->lang->line('cou_Country_updated', FALSE);
		$cou_Country_present=$this->lang->line('cou_Country_present', FALSE);

        $id = check_injections_filter($this->input->post('hidden'));
    	$country_name = check_injections_filter($this->input->post('country_name'));
    	$country_code =check_injections_filter($this->input->post('country_code'));
    	$std_code =check_injections_filter($this->input->post('std_code'));
    	$s_country_name=strtolower($country_name);
    	$s_country_code=strtolower($country_code);
    	$user_id = $this->session->userdata('user_id'); 

    	$this->form_validation->set_rules('country_name', 'Country_Nme', 'required');
		$this->form_validation->set_rules('country_code', 'Country_Code', 'required');

		if ($this->form_validation->run() == FALSE)
        {
                    $this->manage_country();
        }else{
      	        $condition[] = array('where','LOWER(country_code)',$s_country_code);
    	        if ($id) {					  
    			      $condition[] = array('where_not_in','country_id',$id);
    			      $condition[] = array('where','LOWER(country_name)',$s_country_name);
    		    }else{
    		    	
    		    	$condition[] = array('or_where','LOWER(country_name)',$s_country_name);
    		    }

    			$selected_array=array(
								'table_name' =>TABLE_COUNTRY,								
								'table_fields'=>'country_name,country_code',
								'condition'=>$condition,
								'limit' => '',
								'offset' => ''						
					    );

    			 $country_data =array(
								'country_name' => $country_name,
								'country_code' =>$country_code,
								'std_code'=>$std_code,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								
								
								
					    );

    			$country['country'] = $this->master_model->select_data($selected_array);
    			// dump($this->db->last_query());
    			// exit;
    			
    			if(!empty($country['country']))
				{			
					 $this->session->set_flashdata('message',$cou_Country_present);
				     redirect('gc/country/manage_country');
				}else{
					if (!$id) {
						$this->session->set_flashdata('message',$cou_Country_created);
				 		$this->master_model->insert_record(TABLE_COUNTRY,$country_data);
    	         		redirect('gc/country/list_country');
    	        	}else{
						$this->session->set_flashdata('message',$cou_Country_updated);

						$condition=array('country_id'=>$id);
						$country_data=array(
							    'country_name' => $country_name,
								'country_code' =>$country_code,
								'std_code'=>$std_code,
								'modified_on' => date("Y-m-d H:i:s"),
								'modified_by' => $user_id		
					    );
						
						$this->master_model->update_record(TABLE_COUNTRY,$country_data,$condition);
			     		redirect('gc/country/list_country');
			        }
			    }
		}
    }
    function fetch_currency(){
    	admin_auth();
    	$condition[] = array('where','is_active','1');
    	$selected_array = array( 
			                   'table_name' =>TABLE_CURRENCY,
			                   'table_fields' => 'currency_id,currency_name,currency_code,is_active',
			                   'order_by_field'=>'currency_name',
			                   'order'=>'ASC',
			                   'limit'=>'',
			                   'offset'=>'',
			                   'condition'=>$condition
		);

		return $this->master_model->select_data($selected_array);		         
    }
     function disable_country($country_id=""){
     	admin_auth();
     	$cou_Country_disable=$this->lang->line('cou_Country_disable', FALSE);
     	$id=$this->encrypt->decode($country_id);
		$id=encrypt_decrypt_parameters($country_id,'decrypt');
     	$user_id = $this->session->userdata('user_id');
        $country_data=array(
								'is_active' =>'0',								
								'modified_by' => $user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('country_id'=>$id);
     	$this->session->set_flashdata('message',$cou_Country_disable);
		$this->master_model->update_record(TABLE_COUNTRY,$country_data,$condition);
		redirect('gc/country/list_country');
    }
      function enable_country($country_id=""){
      	admin_auth();
      	$cou_Country_enable=$this->lang->line('cou_Country_enable', FALSE);
      	$id=$this->encrypt->decode($country_id);
		$id=encrypt_decrypt_parameters($country_id,'decrypt');
      	$user_id = $this->session->userdata('user_id');
      	$country_data=array(
								'is_active' =>'1',								
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('country_id'=>$id);
     	$this->session->set_flashdata('message',$cou_Country_enable);
		$this->master_model->update_record(TABLE_COUNTRY,$country_data,$condition);
		redirect('gc/country/list_country');
    }
  
 
 
}