<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class User extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('master_model');
		$this->lang->load('masters', '');	
	}

	function index(){	
		$this->list_user();
	}
	
	function list_user() {
		admin_auth();
		$this->page_data['page_title']="List of Users";
		$this->page_data['bredcrum']=array(
			                           
										'User Management'=>'#',
										'Users'=>'#',
										'List User'=>'#',
										);


		    
			      $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                            $condition[] = array('join',TABLE_COMPANY_BRANCH,TABLE_COMPANY_BRANCH.'.company_branch_id ='.TABLE_USERS.'.company_branch_id',);
                            $condition[] = array('join',TABLE_USER_TYPE,TABLE_USER_TYPE.'.user_type_id ='.TABLE_USERS.'.user_type_id','left');
                           // $condition[] = array('where','users.is_active');

                            $select_array=array(
                                'table_name'=>TABLE_USERS,
                                'table_fields'=>TABLE_USERS.'.is_active,user_id,first_name,last_name,email_id,designation,mobile_no,company_branch_name,user_type',
                                'condition'=>$condition,
                                'order_by_field'=>'first_name',
                                'order'=>'DESC',
                                'limit'=>'',
                                'offset'=>''
                            );
                            $users['users']=$this->master_model->select_data($select_array);
                           
                            if(!empty($users['users'])&& is_array($users['users'])){
							
				                   $this->page_data['users'] =  $users['users'];
		 	

  	                          }
      
  	                       $this->load->view('gc/user_list',$this->page_data);
                           
	}
	
	function view_user($user_id) {
      admin_auth();
	 $this->page_data['page_title']="View User";
      $id=$this->encrypt->decode($user_id);
	
		$this->page_data['bredcrum']=array(
			 							
			 							'User Management'=>'#',
			 							'Users'=>'#',
										'List Users'=>site_url(USER_PATH.'list_user'),
										'View User'=>'#',
										);
		             $condition = array();
                            $condition[] = array('where','user_id',$id);
                            $condition[] = array('join',TABLE_COMPANY_BRANCH,TABLE_COMPANY_BRANCH.'.company_branch_id ='.TABLE_USERS.'.company_branch_id');
                            $condition[] = array('join',TABLE_USER_TYPE,TABLE_USER_TYPE.'.user_type_id ='.TABLE_USERS.'.user_type_id','left');
                           // $condition[] = array('where','users.is_active');

                            $select_array=array(
                                'table_name'=>TABLE_USERS,
                                'table_fields'=>'user_id,first_name,last_name,email_id,designation,mobile_no,company_branch_name,user_type',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );
                            $users['users']=$this->master_model->select_data($select_array);
                            

                            if(!empty($users['users'])&& is_array($users['users'])){
							
				                   $this->page_data['users'] =  $users['users'];
		 	

  	                          } 

      
  	                       $this->load->view('gc/user_view',$this->page_data);
	}
	
	function manage_user($user_id="") {
		admin_auth();
 		$this->page_data['u_Branch_Name']=$this->lang->line('u_Branch_Name', FALSE);
 		$this->page_data['u_First_Name']=$this->lang->line('u_First_Name', FALSE);
 		$this->page_data['u_User_Type']=$this->lang->line('u_User_Type', FALSE);
 		$this->page_data['u_Last_Name']=$this->lang->line('u_Last_Name', FALSE);
 		$this->page_data['u_Mobile_Number']=$this->lang->line('u_Mobile_Number', FALSE);
 		$this->page_data['u_Email_Id']=$this->lang->line('u_Email_Id', FALSE);

        $id=$this->encrypt->decode($user_id);
        $this->page_data['branch'] = $this->fetch_branch_name();
        $this->page_data['user_type'] = $this->fetch_user_type();
		if ($id) {
			$this->page_data['page_title']="Edit User";
			$this->page_data['bredcrum']=array(
										
										'User Management'=>'#',
										'Users'=>'#',
										//'List User'=>site_url(USER_PATH.'list_user'),
										'Edit  User'=>'#',
										);
		}else{$this->page_data['page_title']="Add User";
				$this->page_data['bredcrum']=array(
										
										'User Management'=>'#',
										'Users'=>'#',
										//'List User'=>site_url(USER_PATH.'list_user'),
										'Add  User'=>'#',
										);
		}
		
	
         	if (!$id) {
            
	         $this->load->view('gc/user_manage.php',$this->page_data);

			}else{
                     
				$condition = array();
                            $condition[] = array('where','user_id',$id);
                            $condition[] = array('join',TABLE_COMPANY_BRANCH,TABLE_COMPANY_BRANCH.'.company_branch_id ='.TABLE_USERS.'.company_branch_id');
                            $condition[] = array('join',TABLE_USER_TYPE,TABLE_USER_TYPE.'.user_type_id ='.TABLE_USERS.'.user_type_id');
                           // $condition[] = array('where','users.is_active');

                            $select_array=array(
                                'table_name'=>TABLE_USERS,
                                'table_fields'=>'user_id,accessible_branches,first_name,last_name,email_id,designation,mobile_no,company_branch_name,user_type,'.TABLE_USER_TYPE.'.user_type_id,'.TABLE_COMPANY_BRANCH.'.company_branch_id,',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );
                            $users['users']=$this->master_model->select_data($select_array);

		
			if(!empty($users['users'] )&& is_array($users['users']))
			{
				 $this->page_data['users'] = $users['users'] ;
				 
  	  			 
  	        }
		 	$this->load->view('gc/user_manage.php',$this->page_data);
		
		}
	
	}

	function add_user(){

    	 admin_auth();

	 	 $u_User_created=$this->lang->line('u_User_created', FALSE);
 		 $u_User_updated=$this->lang->line('u_User_updated', FALSE);
 		 $u_User_present=$this->lang->line('u_User_present', FALSE);

    	 $id = $this->input->post('hidden');
    	 $branch = $this->input->post('branch');
    	 $user_type =$this->input->post('user_type');
    	 $first_name = check_injections_filter($this->input->post('first_name'));
    	 $last_name = check_injections_filter($this->input->post('last_name'));
    	 $access_branch = $this->input->post('access_branch'); 
    	 $acb=  implode(",",$access_branch);  
    	 $designation = check_injections_filter($this->input->post('designation'));  
    	 $mobile_number = check_injections_filter($this->input->post('mobile_number'));  
    	 $email_id = check_injections_filter($this->input->post('email_id'));
    	 $s_email_id=strtolower($email_id);
    	 $user_pass = $this->get_rand_alphanumeric();
    	 $user_password = md5($user_pass);
    	 $user_id=$this->session->userdata('user_id'); 


    	 $this->form_validation->set_rules('first_name', 'First Name', 'required');
    	 $this->form_validation->set_rules('last_name', 'last Name', 'required'); 
    	 $this->form_validation->set_rules('designation', 'Designation', 'required'); 
    	 $this->form_validation->set_rules('mobile_number', 'Mobile Number', 'required'); 
    	$this->form_validation->set_rules('email_id', 'Email Id', 'required');    
    	if ($this->form_validation->run() == FALSE)
        {
        	$this->manage_user();
        }else{

        	   $condition[] = array('where','LOWER(user_name)',$s_email_id);
        	   $condition[] = array('where','LOWER(email_id)',$s_email_id);
    	       
    	       if ($id) {
    	       	$condition[] = array('where','mobile_no',$mobile_number);
    	    	$condition[] = array('where_not_in','user_id',$id);
               }else{
               	$condition[] = array('or_where','mobile_no',$mobile_number);
               }


		       $selected_array=array(
								'table_name' =>TABLE_USERS,								
								'table_fields'=>'first_name,last_name,mobile_no,email_id,user_name',
								 'limit'=>'',
                                'offset'=>'',
								'condition'=>$condition							
					    );
    	
    	       
    			$user['user'] = $this->master_model->select_data($selected_array);
    			//dump($this->db->last_query());
    			if(!empty($user['user']))
				{			
					 $this->session->set_flashdata('message',$u_User_present);
				     redirect('gc/user/manage_user');
				}else{
					if (!$id) {
						$user_data=array(
    	        				'user_name' => $email_id,
    	        				'user_password' => $user_password,							
    							'first_name' =>$first_name,
								'last_name' => $last_name,
								'accessible_branches' =>$acb,								
								'email_id' => $email_id,
								'designation' =>$designation,
								'mobile_no' =>$mobile_number,
								'company_branch_id' => $branch,
								'user_type_id' =>$user_type,							
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => '',	
								'modified_on' => date("Y-m-d H:i:s")
								
					    );
					
						
				 		$insert = $this->master_model->insert_record(TABLE_USERS,$user_data);
				 		if ($insert) {
				 			$this->session->set_flashdata('message',$u_User_created);
				 			$this->send($email_id,$user_pass);	
				 		}
    	         		
					}else{
						$this->session->set_flashdata('message',$u_User_updated);
				 		$user_data=array(
    	        				'user_name' => $email_id,
    	        				// 'user_password' => $user_password,							
    							'first_name' =>$first_name,
								'last_name' => $last_name,
								'accessible_branches' =>$acb,	
								'email_id' => $email_id,
								'designation' =>$designation,
								'mobile_no' =>$mobile_number,
								'company_branch_id' => $branch,
								'user_type_id' =>$user_type,							
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")
								
					    );
				        $condition=array('user_id'=> $id);
						$this->master_model->update_record(TABLE_USERS,$user_data,$condition);
			     		redirect('gc/user/list_user');	
					}
				}
        }
	 
    }
     function fetch_branch_name(){
     	admin_auth();
     	$condition[] = array('where','is_active','1');
    	$selected_array = array( 
			                   'table_name' =>TABLE_COMPANY_BRANCH,
			                   'table_fields' => 'company_branch_id,company_branch_name,is_active',
			                   'order_by_field'=>'company_branch_name',
			                   'condition'=>$condition,
			                   'order'=>'ASC',
			                   'limit'=>'',
			                   'offset'=>''

		);

		return $this->master_model->select_data($selected_array);		         
    }
    function fetch_user_type(){
    	admin_auth();
		$condition[] = array('where','is_active','1');
    	$selected_array = array( 
			                   'table_name' =>TABLE_USER_TYPE,
			                   'table_fields' => 'user_type_id,user_type',
			                   'order_by_field'=>'user_type',
			                   'condition'=>$condition,
			                   'order'=>'ASC',
			                   'limit'=>'',
			                   'offset'=>''
		);

		return $this->master_model->select_data($selected_array);		         
    }
      function get_rand_alphanumeric() {
    
    		$alph = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        	$code='';
       		 $i=0;
       		 while($i<9){
           		 $position=rand(0,35);
            	 $code=$code.substr($alph,$position,1);
                 $i++;
             }
           return $code;
    }
     function disable_user($user_id){
     	admin_auth();
     	$u_User_disable=$this->lang->line('u_User_disable', FALSE);
     	$id=$this->encrypt->decode($user_id);
     	$user_id = $this->session->userdata('user_id'); 
        $user_data=array(
								'is_active' =>'0',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('user_id'=>$id);
     	$this->session->set_flashdata('message',$u_User_disable);
		$this->master_model->update_record(TABLE_USERS,$user_data,$condition);
		redirect('gc/user/list_user');
    }
    function enable_user($user_id){
      	admin_auth();
      	$u_User_enable=$this->lang->line('u_User_enable', FALSE);
      	$id=$this->encrypt->decode($user_id);
      	$user_id = $this->session->userdata('user_id'); 
      $user_data=array(
								'is_active' =>'1',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('user_id'=>$id);
     	$this->session->set_flashdata('message',$u_User_enable);
		$this->master_model->update_record(TABLE_USERS,$user_data,$condition);
		redirect('gc/user/list_user');
    } 
    function send($email_id,$user_pass){
   	
    	$mailContent = "Welcome to Nityam Hygiene - Refill Management System.<br>	   
     		Please find below your login details<br>
		 		Username=$email_id<br>
				Password=$user_pass<br>
				<a href='$url'>$url</a><p>";
  //   $mail->Body = $mailContent;
 	$this->load->library('email'); 
    $this->email->from('shreyas@nityam.in','Shreyas');
    $this->email->to($email_id);
    $this->email->subject("Login Credentials");
    $this->email->message($mailContent);
    $this->email->set_newline("\r\n");
    $this->email->send();
     if (!$this->email->send()) {
    show_error($this->email->print_debugger()); }
     else {
       redirect('gc/user/list_user');
     }
  }
  
}