<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Refill_sale_data extends CI_Controller {

	function __construct()	{
		parent::__construct();
		//$this->lang->load('masters', '');
		  $language = $this->session->userdata('language'); 
        if ($language=='hindi') {
               $this->lang->load('hindi', '');
        }else{
              $this->lang->load('masters', '');
            }
	}

	function index()	{	
		$this->list_refill_sale_data();
	}

	 function list_refill_sale_data($days='',$due_day,$query_id = 0, $sort_by = 'dispenser_sales_id', $sort_order = 'asc', $offset = 0) {
		admin_auth();
   
        $day=$this->encrypt->decode($days);
        $due_day=$this->encrypt->decode($due_days);			
		$this->page_data['page_title']="List of Refill Sale Data";
		$this->page_data['bredcrum']=array(
										'Refill Sales'=>'#',
										'Manage Refill Sales'=>site_url('gc/refill_sale_data/list_refill_sale_data'),
										'List Refill Sale Data'=>'#',
										);

		$dues = $this->input->post('dues');
		if ($day) {
			$dues = $day;
		}
		if ($due_day) {
			$dues = $due_day;
		}
		$this->session->set_userdata('due',$dues);
		$access_branch= $this->session->userdata('access_branch');
		$acb =  explode( ',',$access_branch);
		$customer_id = $this->input->post('customer_id');
		$condition[] = array('join',TABLE_DISPENSER_REFILL_DETAILS.' as a','b.dispenser_sales_id = a.dispenser_sales_id','inner');

			// $condition[] = array('join',TABLE_DISPENSER_SALES.' as f','f.dispenser_sales_id = b.dispenser_sales_id','inner');

		$condition[] = array('join',TABLE_PRODUCT.' as p','a.product_id = p.product_id','inner');
		$condition[] = array('join',TABLE_PRODUCT.' as p1','b.product_id = p1.product_id','inner');
        $condition[] = array('join',TABLE_CUSTOMER.' as c','c.customer_id = b.customer_id','inner');
        $condition[] = array('join',TABLE_USERS.' as u','u.user_id = b.sales_person_id','inner');
        if ($customer_id) {
        		
			$condition[] = array('where','b.customer_id',$customer_id);
		}
        
        if ($dues==0) {
        	$this->page_data['heading']="Today's Refill Due";
       		$qry_part = 'next_refill_date = ( CURDATE( ) ) ';
       	}elseif($dues==1){
       		$this->page_data['heading']="All Previous Refill Due";
       		$qry_part = 'next_refill_date < ( CURDATE( ) ) ';
       	}else{
       		$this->page_data['heading']="Next ".$dues." days Refill Due";
       		$qry_part = 'next_refill_date BETWEEN NOW( ) AND DATE_ADD( NOW( ) , INTERVAL"'.$dues.'"DAY )';
       	}
       	if ($access_branch!='') {
             $condition[] = array('where_in','b.company_branch_id',$acb);
        }	
        $condition[] = array('where',$qry_part);

        // $selected_array=array(
        //                       'table_name'=>TABLE_DISPENSER_SALES.' as b',
        //                       'table_fields'=>'p1.product_name as dispenser,b.sales_type,u.first_name,u.last_name,a.dispenser_refill_details_id,c.customer_name,p.dispenser_name, p.product_name, b.dispenser_quantity, a.refill_location, b.installation_date,a.refill_date, a.next_refill_date, a.duration_days, a.comments, a.product_id, a.dispenser_sales_id, b.dispenser_sales_id,b.product_id, b.customer_id, p.product_id,c.customer_id',
        //                        'condition'=>$condition,
        //                        'limit'=>'',
        //                        //'order_by_field'=>'a.branch_salable_geography_id',
        //                        //'group_by_field'=>'a.customer_name',
        //                        'offset'=>''
        //                       );
        $sort_columns = array();
        $search_array=array(
							'limit' => $limit,
							'offset' => $offset,
							'sort_by' => $sort_by,
							'sort_type' => $sort_type,
							'sort_order' => $sort_order,
							'sort_columns'=> $sort_columns,
							'table_fields'=>'p1.product_name as dispenser,b.sales_type,u.first_name,u.last_name,a.dispenser_refill_details_id,c.customer_name,p.dispenser_name, p.product_name, b.dispenser_quantity, a.refill_location, b.installation_date,a.refill_date, a.next_refill_date, a.duration_days, a.comments, a.product_id, a.dispenser_sales_id, b.dispenser_sales_id,b.product_id, b.customer_id, p.product_id,c.customer_id',
							'table_name'=>TABLE_DISPENSER_SALES.' as b',
							'cond'=> $condition,
							);
        //$refill_sale['refill_sale'] = $this->master_model->select_data($selected_array);
        //dump($this->db->last_query());
        $results = $this->master_model->search($search_array);
     
        if ($customer_id) {
        		
			foreach($refill_sale['refill_sale'] as $k=>$v){

               $this->page_data['customer'] = $v['customer_name'];
               $this->page_data['customer_name'] = " For ". $this->page_data['customer'];
               $this->page_data['dues'] = $dues;
               
            }
		}
        if(!empty($results)&& is_array($results))
			{
				$this->page_data['refill_sale'] = $results['rows'];
				$this->page_data['num_results'] = $results['num_rows'];
			}
			else
			{
				$results='';
			}
			$this->page_data['offset'] = $offset;
			/// pagination
			$this->load->library('pagination');
			$config = array();
			$config['base_url'] = site_url("gc/refill_sale_data/list_refill_sale_data/$query_id/$sort_by/$sort_order");
			$config['total_rows'] = $this->page_data['num_results'];
			$config['per_page'] = $limit;
			$config['uri_segment'] = 7;
			$config['full_tag_open'] = '<span class=\'paging\'>';
			$config['full_tag_close'] = '</span>';
			$config['first_link'] = 'First';
			$config['prev_link'] = '<<';
			$config['next_link'] = '>>';
			$config['last_link'] = 'Last';
			$this->pagination->initialize($config);
			
			$this->page_data['pagination'] = $this->pagination->create_links();
			$this->page_data['sort_by'] = $sort_by;
			$this->page_data['sort_order'] = $sort_order;
			//$data['purpose'] = $purpose;
			$this->page_data['query_id'] = $query_id;
      //  if(!empty($refill_sale['refill_sale'] )&& is_array($refill_sale['refill_sale'] )){


				  // $this->page_data['refill_sale'] = $refill_sale['refill_sale'];
		 	
  	   //  } 
  	
		$this->load->view('gc/refill_sale_data_list.php',$this->page_data);
	}
	
	function view_refill_sale_data() {
		admin_auth();
		$this->_page_data['page_title']="View Refill Sale Data";
		$this->_page_data['bredcrum']=array(
										'Refill Sales'=>'#',
										'Manage Refill Sales'=>site_url('gc/refill_sale_data/list_refill_sale_data'),
										'List Refill Sale Data'=>site_url('gc/refill_sale_data/list_refill_sale_data'),
										'View Refill Sale Data'=>'#',
										);
		$this->load->view('gc/refill_sale_data_view.php',$this->_page_data);
	}
	
	function manage_refill_sale_data($purpose=NULL) {
		admin_auth();


		if($purpose=='')
			$purpose='Show';


		$this->_page_data['lable_refill_sale_data_customer_name']=$this->lang->line('lable_refill_sale_data_customer_name', FALSE);
		$this->_page_data['lable_refill_sale_data_refill_due_for']=$this->lang->line('lable_refill_sale_data_refill_due_for', FALSE);

		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']="Show Refill Due";
		$this->_page_data['bredcrum']=array(
										'Refill Sales'=>'#',
										'Manage Refill Sales'=>site_url('gc/refill_sale_data/list_refill_sale_data'),
										//'List Refill Sale Data'=>site_url('gc/refill_sale_data/list_gc_type'),
										$purpose.' Refill Sale Data'=>'#',
										);
		// $customer_cond = array();
		// $customer_cond[] = array('where','is_active','1');
		// $select_array = array(
		// 						'table_name'=>TABLE_CUSTOMER,
		// 						'table_fields'=>'customer_name,customer_id',
		// 						'condition'=>$customer_cond,
		// 						'sort_by'=>'customer_id',
		// 						'order_by_field'=>'customer_name',
		// 						'order'=>'ASC',
		// 						'limit'=>'',
		// 						'offset'=>''
		// 						);
		// $customer_data=$this->master_model->select_data($select_array);
		// $customer_cnt_data=count($customer_data);
		// $this->_page_data['customer_array'] = '';
		// if($customer_cnt_data > 0)
		// {
		// 	foreach($customer_data as $cKey => $cValue)
		// 	{
		// 		$this->_page_data['customer_array'][''] = 'Select Customer Name';
		// 		$this->_page_data['customer_array'][$cValue['customer_id']] = $cValue['customer_name'];
		// 	}
		// }
		$this->load->view('gc/refill_sale_data_manage.php',$this->_page_data);
	}
	
	function change_refill_data($purpose=NULL) {
		admin_auth();
		if($purpose=='')
			$purpose='Change';
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']=$purpose." Refill Sale Data";
		$this->_page_data['bredcrum']=array(
										'Refill Sales'=>'#',
										'Manage Refill Sales'=>site_url('gc/refill_sale_data/list_refill_sale_data'),
										//'List Refill Sale Data'=>site_url('gc/refill_sale_data/list_gc_type'),
										$purpose.' Refill Sale Data'=>'#',
										);
		$this->load->view('gc/change_refill.php',$this->_page_data);
	}
	
	function scan_qr_code($purpose=NULL) {
		admin_auth();
		if($purpose=='')
			$purpose='Change';
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']="Sacn QR Code";
		$this->_page_data['bredcrum']=array(
										'Refill Sales'=>'#',
										'Manage Refill Sales'=>site_url('gc/refill_sale_data/list_refill_sale_data'),
										//'List Refill Sale Data'=>site_url('gc/refill_sale_data/list_gc_type'),
										'Sacn QR Code'=>'#',
										);
		$this->load->view('gc/scan_qr_code.php',$this->_page_data);
	}
	
	function change_refill($dispenser_refill_details_id)
	{
		// if($purpose=='')
		// 	$purpose='Add';
		/*
		Name:- Shreyas
		Date 7 August 2019
		to change the heading 
		*/

		 if($dispenser_refill_details_id){
		 	$purpose='Refill Sales Manage';
		 	$this->_page_data['tb_heading']='Change Refill';
		 }else{
		 	$purpose='Dispenser Sale Data';
		 	$this->_page_data['tb_heading']='Refill Details';
		 }
			
				
		$dispenser_refill_details_id = $this->encrypt->decode(($dispenser_refill_details_id));
		$dues_day = $this->encrypt->decode(($dues_day));
		
		$cond=array();		
		$cond[]=array('where','dispenser_refill_details_id',$dispenser_refill_details_id);
		//$cond[]=array('where','dispenser_sales_id',$dispenser_sales_id);
		$cond[]=array('join',TABLE_DISPENSER_SALES.' as A','A.dispenser_sales_id=F.dispenser_sales_id','left');	
		$cond[]=array('join',TABLE_CUSTOMER.' as C','A.customer_id=C.customer_id','left');
		$cond[]=array('join',TABLE_COMPANY_BRANCH.' as D','A.company_branch_id=D.company_branch_id','left');		
		$cond[]=array('join',TABLE_PRODUCT.' as B','F.product_id=B.product_id','left');		
		$cond[]=array('join',TABLE_USERS.' as E','A.sales_person_id=E.user_id','left');		
		$cond[]=array('join',TABLE_PRODUCT.' as G','A.product_id=G.product_id','left');		
			
		$company_array=array(
							'table_name'=>TABLE_DISPENSER_REFILL_DETAILS." as F",
							'table_fields'=>'A.company_branch_id,A.customer_id,E.first_name,E.last_name, A.dispenser_quantity,A.installation_date,C.customer_name, D.company_branch_name, B.product_name ,B.stock_quantity, B.product_prefix,A.product_id,F.tracking_numbers,F.duration_days,F.quantity ,F.refill_date,F.next_refill_date,F.refill_location,F.product_id as refill_id,F.dispenser_refill_details_id,A.dispenser_sales_id,G.product_name as dispenser_name',
							'condition'=>$cond,
							'sort_by' => 'dispenser_sales_id', 
							'limit'=>'',
							'offset'=>''
							);											
		$company_data=$this->master_model->select_data($company_array);
		$company_cnt_data=count($company_data);
		//dump($this->db->last_query());
		
		if($company_cnt_data >0){
			$this->_page_data['sales_person_name']= isset($company_data[0]['sales_person_name']) && !empty($company_data[0]['sales_person_name']) ? $company_data[0]['sales_person_name'] :'';
			$this->_page_data['company_name']= isset($company_data[0]['company_name']) && !empty($company_data[0]['company_name']) ? $company_data[0]['company_name'] :'';
			$this->_page_data['first_name']= isset($company_data[0]['first_name']) && !empty($company_data[0]['first_name']) ? $company_data[0]['first_name'] :'';
			$this->_page_data['last_name']= isset($company_data[0]['last_name']) && !empty($company_data[0]['last_name']) ? $company_data[0]['last_name'] :'';
			$this->_page_data['dispenser_quantity']= isset($company_data[0]['dispenser_quantity']) && !empty($company_data[0]['dispenser_quantity']) ? $company_data[0]['dispenser_quantity'] :'';
			$this->_page_data['installation_date']= isset($company_data[0]['installation_date']) && !empty($company_data[0]['installation_date']) ? $company_data[0]['installation_date'] :'';
			$this->_page_data['product_name']= isset($company_data[0]['product_name']) && !empty($company_data[0]['product_name']) ? $company_data[0]['product_name'] :'';
			$this->_page_data['product_prefix']= isset($company_data[0]['product_prefix']) && !empty($company_data[0]['product_prefix']) ? $company_data[0]['product_prefix'] :'';
			$this->_page_data['stock_quantity']= isset($company_data[0]['stock_quantity']) && !empty($company_data[0]['stock_quantity']) ? $company_data[0]['stock_quantity'] :'';
			$this->_page_data['customer_id']= isset($company_data[0]['customer_id']) && !empty($company_data[0]['customer_id']) ? $company_data[0]['customer_id'] :'';
			$this->_page_data['company_branch_id']= isset($company_data[0]['company_branch_id']) && !empty($company_data[0]['company_branch_id']) ? $company_data[0]['company_branch_id'] :'';
			$product_id= isset($company_data[0]['product_id']) && !empty($company_data[0]['product_id']) ? $company_data[0]['product_id'] :'';
			$this->_page_data['customer_name']= isset($company_data[0]['customer_name']) && !empty($company_data[0]['customer_name']) ? $company_data[0]['customer_name'] :'';$this->_page_data['company_branch_name']= isset($company_data[0]['company_branch_name']) && !empty($company_data[0]['company_branch_name']) ? $company_data[0]['company_branch_name'] :'';
			
			$tracking_numbers= isset($company_data[0]['tracking_numbers']) && !empty($company_data[0]['tracking_numbers']) ? $company_data[0]['tracking_numbers'] :'';
			$this->_page_data['duration_days']= isset($company_data[0]['duration_days']) && !empty($company_data[0]['duration_days']) ? $company_data[0]['duration_days'] :'';
			$this->_page_data['quantity']= isset($company_data[0]['quantity']) && !empty($company_data[0]['quantity']) ? $company_data[0]['quantity'] :'';
			$this->_page_data['refill_date']= isset($company_data[0]['refill_date']) && !empty($company_data[0]['refill_date']) ? $company_data[0]['refill_date'] :'';
			$this->_page_data['next_refill_date']= isset($company_data[0]['next_refill_date']) && !empty($company_data[0]['next_refill_date']) ? $company_data[0]['next_refill_date'] :'';
			$this->_page_data['refill_location']= isset($company_data[0]['refill_location']) && !empty($company_data[0]['refill_location']) ? $company_data[0]['refill_location'] :'';
			$this->_page_data['refill_id']= isset($company_data[0]['refill_id']) && !empty($company_data[0]['refill_id']) ? $company_data[0]['refill_id'] :'';
			$this->_page_data['dispenser_name']= isset($company_data[0]['dispenser_name']) && !empty($company_data[0]['dispenser_name']) ? $company_data[0]['dispenser_name'] :'';
			$dispenser_sales_id= isset($company_data[0]['dispenser_sales_id']) && !empty($company_data[0]['dispenser_sales_id']) ? $company_data[0]['dispenser_sales_id'] :'';
		}
		
		
		
		$refill_cond = array();
		$refill_cond[] = array('where','is_active','1');
		$refill_cond[] = array('where','product_type','refill');
		$select_array = array(
								'table_name'=>TABLE_PRODUCT,
								'table_fields'=>'product_name,product_id',
								'condition'=>$refill_cond,
								'sort_by'=>'product_id',
								'order_by_field'=>'product_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$refill_data=$this->master_model->select_data($select_array);
		$refill_cnt_data=count($refill_data);
		$this->_page_data['refill_array'] = '';
		if($refill_cnt_data > 0)
		{
			foreach($refill_data as $cKey => $cValue)
			{
				$this->_page_data['refill_array'][''] = 'Select Refill Name';
				$this->_page_data['refill_array'][$cValue['product_id']] = $cValue['product_name'];
			}
		}
		
		$tracking_numbers_arr = explode(',', $tracking_numbers);
		$tracking_cond = array();		 
		$tracking_cond[] = array('where_in','tracking_numbers_id',$tracking_numbers_arr);
		$select_array = array(
								'table_name'=>TABLE_TRACKING_NUMBERS,
								'table_fields'=>'group_concat(tracking_number) as tracking_numbers',
								'condition'=>$tracking_cond,
								'sort_by'=>'tracking_numbers_id',
								'order_by_field'=>'tracking_number',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$tracking_data=$this->master_model->select_data($select_array);
		
		$tracking_cnt_data=count($tracking_data);
		$this->_page_data['tracking_array'] = '';
		if($tracking_cnt_data > 0)
		{
			$this->_page_data['tracking_numbers_name']= isset($tracking_data[0]['tracking_numbers']) && !empty($tracking_data[0]['tracking_numbers']) ? $tracking_data[0]['tracking_numbers'] :'';
		}
		
		//$this->_page_data['purpose']=$purpose;
		$this->_page_data['tracking_numbers']=$tracking_numbers;
		$this->_page_data['dispenser_sales_id']=$dispenser_sales_id;
		$this->_page_data['dispenser_refill_details_id']=$dispenser_refill_details_id;
		$this->_page_data['page_title']=$purpose;
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										' Manage Dispenser Sales'=>site_url('gc/refill_sale_data/list_dispenser_sale_data'),
										$purpose=>'#',
										'Refill Data'=>'#',
										);
		$this->_page_data['form_action'] = 'gc/refill_sale_data/submit_change_refill_details';
		//$this->_page_data['dues_day']=$dues_day;
					
		$this->load->view('gc/change_refill_details.php',$this->_page_data);
		
	}
	
	function submit_change_refill_details()
	{
		
		admin_auth();
		$user_id = $this->session->userdata('user_id');
						
		$dispenser_sales_id=check_injections_filter($this->input->post('dispenser_sales_id'));
		$dispenser_refill_details_id=check_injections_filter($this->input->post('dispenser_refill_details_id'));
		$refill_location=($this->input->post('refill_location'));
		$refill_date=($this->input->post('refill_date'));
		$programming_days=($this->input->post('programming_days'));
		$tracking_no=($this->input->post('tracking_no'));
		$refill_product_id=($this->input->post('refill_product_id'));
		$tracking_no=($this->input->post('tracking_no'));
		$refill_quantity=($this->input->post('refill_quantity'));
		$customer_id=check_injections_filter($this->input->post('customer_id'));
		$company_branch_id=check_injections_filter($this->input->post('company_branch_id'));
		$refill_comments=check_injections_filter($this->input->post('refill_comments'));
		
		$tracking_no = explode(',', $tracking_no);
		if(isset($tracking_no)){
			
			 $refill_location1 = isset($refill_location) && !empty($refill_location) ? check_injections_filter($refill_location) : ''; 
			$refill_date = isset($refill_date) && !empty($refill_date) ? check_injections_filter($refill_date) :'';
			$programming_days1 = isset($programming_days) && !empty($programming_days) ? check_injections_filter($programming_days) :'';
			$refill_product_id1 = isset($refill_product_id) && !empty($refill_product_id) ? check_injections_filter($refill_product_id) :'';
			$refill_quantity1 = isset($refill_quantity) && !empty($refill_quantity) ? check_injections_filter($refill_quantity) :'';
			$refill_comments1 = isset($refill_comments) && !empty($refill_comments) ? check_injections_filter($refill_comments) : ''; 
			
			$des_refill_date=date("Y-m-d",strtotime($refill_date));
			$cur_date=date("Y-m-d");
			$next_refill_date=date('Y-m-d', strtotime($cur_date. ' + '.$programming_days1.' day'));
			  $data_log = array(
								'dispenser_sales_id'=>$dispenser_sales_id,
								'product_id'=>$refill_product_id1,
								'duration_days'=>$programming_days1,
								'quantity'=>$refill_quantity1,
								'refill_date'=>$des_refill_date,
								'next_refill_date'=>$next_refill_date,
								'refill_location'=>$refill_location1,
								'comments'=>$refill_comments1,
								'modified_by'=>$user_id,
								'is_active'=>'1',
								'modified_on' =>date("Y-m-d H:i:s")							
							); 
			
			 $dispenser_sales_condition=array('dispenser_refill_details_id'=>$dispenser_refill_details_id);
			 $this->master_model->update_record(TABLE_DISPENSER_REFILL_DETAILS,$data_log,$dispenser_sales_condition); 
			
												
				foreach($tracking_no as $cKey1 => $cVal1){
					$tracking_num = isset($cVal1) && !empty($cVal1) ? ($cVal1) : '';
					 $tracking_log = array(
									'company_branch_id'=>$company_branch_id,
									'customer_id'=>$customer_id,
									'dispenser_sales_id'=>$dispenser_sales_id,
									'dispenser_refill_details_id'=>$dispenser_refill_details_id,
									'refill_date'=>$des_refill_date,
									'next_refill_date'=>$next_refill_date,
									'modified_by'=>$user_id,
									'modified_on' =>date("Y-m-d H:i:s")							
								); 
					//$this->master_model->insert_record(TABLE_TRACKING_DETAILS,$data_log);
					$tracking_condition=array('tracking_numbers_id'=>$tracking_num);
					$this->master_model->update_record(TABLE_TRACKING_DETAILS,$tracking_log,$tracking_condition); 
					
					
				}
			
		}
		//$date = get_change_refill_date();
		// echo $date = $this->session->userdata('due');
		// exit;
		//$day_date=$this->encrypt->encode($date);
		$this->session->set_flashdata('message','Refill Changed Successfully');
		//redirect($referred_from, 'refresh');
		//$this->list_refill_sale_data($days,$day_date);
		redirect(REFILL_SALES_DATA."list_refill_sale_data/$day_dates");
	}
	 function customer(){
	 	
	 	$customer_id=check_injections_filter($this->input->post('customer_id'));

	 	//echo $customer_id;	
    	$customer_cond = array();
		$customer_cond[] = array('where','is_active','1');
		$customer_cond[] = array('like','customer_name',$customer_id);
		$select_array = array(
								'table_name'=>TABLE_CUSTOMER,
								'table_fields'=>'customer_name,customer_id',
								'condition'=>$customer_cond,
								'sort_by'=>'customer_id',
								'order_by_field'=>'customer_name',
								'group_by_field'=>'customer_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$customer_data=$this->master_model->select_data($select_array);
		//dump($this->db->last_query());
		$customer_cnt_data=count($customer_data);
		if($customer_cnt_data > 0)
		{
			$result=[];
			$output='';
		 		foreach($customer_data as $row)
                     {
						  $result[] = ['id'=>$row['customer_id'], 'text'=>$row['customer_name']];
						 //$result['id']=$row['customer_id'];
						// $result['name']=$row['customer_name'];
                  		 // $output .= '<option value='.$row['customer_id'].'>'.$row['customer_name'].'</option>';

                     }

          echo json_encode($result);
		}
    }
}