<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class State extends CI_Controller {

	function __construct()	{
		parent::__construct();
		$this->load->model('master_model');
		//$this->lang->load('masters', '');
		$language = $this->session->userdata('language'); 
		if ($language=='hindi') {
			$this->lang->load('hindi', '');
		}else{
			$this->lang->load('masters', '');
		}
		// /$this->lang->load('language_switch', '');
	//error_reporting(E_ALL);
	}

	function index()	{	
		$this->manage_state();
	}
	
	function list_state() {
		admin_auth();
		$this->page_data['page_title']="List of States";
		$this->page_data['bredcrum']=array(		
										'Master'=>'#',	                           
										'State'=>'#',
										'List of States'=>'#',
										);

		 $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                            $condition[] = array('join',TABLE_COUNTRY,TABLE_STATE.'.country_id ='.TABLE_COUNTRY.'.country_id');
                           // $condition[] = array('where','users.is_active');

                            $selected_array=array(
                                'table_name'=>TABLE_STATE,
                                'table_fields'=>TABLE_STATE.'.is_active,state_id,country_name,state_name,'.TABLE_COUNTRY.'.country_id',
                                'condition'=>$condition,
                                'order_by_field'=>'state_name',
                                'group_by_field'=>'state_name',
                                'order'=>'ASC',
                                'limit'=>'',
                                'offset'=>''
                            );


		$state['state'] = $this->master_model->select_data($selected_array);

		 if(!empty($state['state'])&& is_array($state['state'])){
							
				 $this->page_data['state'] =   $state['state'];
		 	

  	    }    
  	        $this->load->view('gc/list_state',$this->page_data);
	}	
	
	function view_state($state_id) {
		
     admin_auth();
     //$id=$this->encrypt->decode($state_id);
	 $id=encrypt_decrypt_parameters($state_id,'decrypt');
		$this->_page_data['page_title']="View State";
		$this->_page_data['bredcrum']=array(
			 							'Master'=>'#',	
			 							'State'=>'#',
										'List of States'=>site_url('gc/state/list_state'),
										'View State'=>'#',
										);
		
// 
		
		 $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                            $condition[] = array('join',TABLE_COUNTRY,TABLE_STATE.'.country_id ='.TABLE_COUNTRY.'.country_id');
                          $condition[] = array('where','state_id',$id);

                            $selected_array=array(
                                'table_name'=>TABLE_STATE,
                                'table_fields'=>TABLE_STATE.'.is_active,state_id,country_name,state_name,'.TABLE_COUNTRY.'.country_id',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );
		
		$state['state'] = $this->master_model->select_data($selected_array);
		
		if(!empty($state['state'])&& is_array($state['state']))
			{
				 $this->_page_data['state'] = $state['state'];		 
  	        }
		$this->load->view('gc/view_state.php',$this->_page_data);
	}
	
	function manage_state($state_id="") {
		
		admin_auth();
		//$id=$this->encrypt->decode($state_id);
		 $id=encrypt_decrypt_parameters($state_id,'decrypt');
		$this->_page_data['country'] = $this->fetch_country();
 			
 		$this->_page_data['st_State_Name']=$this->lang->line('st_State_Name', FALSE);
 		$this->_page_data['st_State_Code']=$this->lang->line('st_State_Code', FALSE);
 		$this->_page_data['st_country']= $this->lang->line('st_country', FALSE);
 		if ($id) {$this->_page_data['page_title']="Edit  State";
 		$this->_page_data['bredcrum']=array(
										'Master'=>'#',	
										'State'=>'#',
										'List of States'=>site_url(STATE.'list_state'),
										'Edit State'=>'#',
										);
 		}else{$this->_page_data['page_title']="Add  State";
 				$this->_page_data['bredcrum']=array(
										'Master'=>'#',	
										'State'=>'#',
										//'List User'=>site_url(USER_PATH.'list_user'),
										'Add State'=>'#',
										);
 		}
		
		

         							
		if (!$id) {
            
	       $this->load->view('gc/add_state.php',$this->_page_data);

		}else{
                     	
		 $condition = array();
                            //$condition[] = array('where',TABLE_COMPANY.'.company_id',$company_id);
                            $condition[] = array('join',TABLE_COUNTRY,TABLE_STATE.'.country_id ='.TABLE_COUNTRY.'.country_id');
                           // $condition[] = array('where','users.is_active');
                            $condition[] = array('where','state_id',$id);

                            $selected_array=array(
                                'table_name'=>TABLE_STATE,
                                'table_fields'=>TABLE_STATE.'.is_active,state_id,country_name,state_name,'.TABLE_COUNTRY.'.country_id',
                                'condition'=>$condition,
                                'limit'=>'',
                                'offset'=>''
                            );
		$state['state'] = $this->master_model->select_data($selected_array);
		
		if(!empty($state['state'] )&& is_array($state['state']))
			{
				 $this->_page_data['state'] = $state['state'] ;
				 
  	  			 
  	        }
		  $this->load->view('gc/add_state.php',$this->_page_data); 
		
		}

	}
	
    function add_state(){
    	
    	 admin_auth();

 		$st_State_created=$this->lang->line('st_State_created', FALSE);
 		$st_State_updated=$this->lang->line('st_State_updated', FALSE);
 		$st_State_present=$this->lang->line('st_State_present', FALSE);

        $id = check_injections_filter($this->input->post('hidden'));
    	$state_name= check_injections_filter($this->input->post('state_name'));
    	$country_name = check_injections_filter($this->input->post('country_name'));
    	$s_state_name=strtolower($state_name);
    	$user_id = $this->session->userdata('user_id'); 

    	/* $this->form_validation->set_rules('state_name', 'State Name', 'required');
    	if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('gc/add_state.php'); 
        }else{ */
			$condition[] = array('where','LOWER(state_name)',$s_state_name);
    	 	if ($id) {

    			$condition[] = array('where_not_in','state_id',$id);
    		}
    
    	
    		    $state_data=array(
								'state_name' => $state_name,
								'country_id' =>$country_name,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => '',	
								'modified_on' => date("Y-m-d H:i:s")
								
					    );

    	
    	     //$condition[] = array('where','state_id',$id);

    		    $selected_array=array(
								'table_name' =>TABLE_STATE,								
								'table_fields'=>'state_name',
								'limit'=>'',
								'offset'=>'',
								'condition'=>$condition							
					        );
    			$state['state'] = $this->master_model->select_data($selected_array);
    			if(!empty($state['state']))
				{
					 	$this->session->set_flashdata('message',$st_State_present);
				     	redirect('gc/state/manage_state');
  	        	}else{
    		         if (!$id) {
						$this->session->set_flashdata('message',$st_State_created);
				 		$this->master_model->insert_record(TABLE_STATE,$state_data);
    	         		redirect('gc/state/list_state');
    	             }else{			
						$this->session->set_flashdata('message',$st_State_updated);
						$state_data=array(
								'state_name' => $state_name,
								'country_id' =>$country_name,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")
								
					    );
						$condition=array('state_id'=>$id);
						$this->master_model->update_record(TABLE_STATE,$state_data,$condition);
			     		redirect('gc/state/list_state');
					  }
				} 
		//} 	
    }

    function fetch_country(){
    	admin_auth();
    	$condition[] = array('where','is_active','1');
    	$selected_array = array( 
			                   'table_name' =>TABLE_COUNTRY,
			                   'table_fields' => 'country_id,country_name,is_active',
			                   'order_by_field'=>'country_name',
			                   'order'=>'ASC',
			                   'limit'=>'',
			                   'offset'=>'',
			                   'condition'=>$condition
		);

		return $this->master_model->select_data($selected_array);		         
    }
    function disable_state($state_id){
    	admin_auth();
    	
    	$st_State_disable=$this->lang->line('st_State_disable', FALSE);
    	//$id=$this->encrypt->decode($state_id);
		 $id=encrypt_decrypt_parameters($state_id,'decrypt');
     $state_data=array(
								'is_active' =>'0',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => $user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('state_id'=>$id);
     	$this->session->set_flashdata('message',$st_State_disable);
		$this->master_model->update_record(TABLE_STATE,$state_data,$condition);
		redirect('gc/state/list_state/');
    }
    function enable_state($state_id){
    	admin_auth();
    	$st_State_enable=$this->lang->line('st_State_enable', FALSE);
     // $id=$this->encrypt->decode($state_id);
	   $id=encrypt_decrypt_parameters($state_id,'decrypt');
      $state_data=array(
								'is_active' =>'1',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('state_id'=>$id);
     	$this->session->set_flashdata('message',$st_State_enable);
		$this->master_model->update_record(TABLE_STATE,$state_data,$condition);
		redirect('gc/state/list_state/');
    }

 


}