<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Customer_tracking_reports extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('master_model');
		//$this->lang->load('masters', '');	
		    $language = $this->session->userdata('language'); 
    		if ($language=='hindi') {
      	       $this->lang->load('hindi', '');
   			}else{
      		    $this->lang->load('masters', '');
            }
			error_reporting(E_ALL);

	}

	function index(){	

		 $this->show_tracking();
	}

	function show_tracking($query_id = 0,$sort_by = 'd.dispenser_sales_id',$sort_order = 'asc',$offset = 0,$sort_type=0){
	    admin_auth();
	    $limit = LIMIT_PER_PAGE;		
		$this->page_data['page_title']="Customer Tracking Reports";
		$this->page_data['bredcrum']=array(
										'Reports'=>'#',
										'Customer Tracking Reports'=>'#'										
										);


		$this->load->library('NF_Query_search');
		$this->nf_query_search->load_query($query_id);

		$query_array = array(						
				'dispenser_name'=>$this->input->get('dispenser_name'),
 				'customer_name'=>$this->input->get('customer_name'),

		);
		$dispenser_name=check_injections_filter($query_array['dispenser_name']);
		$customer_name=check_injections_filter($query_array['customer_name']);


		$access_branch= $this->session->userdata('access_branch');
		$condition = array();
		$condition[] = array('join',TABLE_CUSTOMER.' as c','c.customer_id = t.possessed_by','left');
		$condition[] = array('join',TABLE_PRODUCT.' as p','p.product_id = t.product_id','left');
		$condition[] = array('join',TABLE_COMPANY_BRANCH.' as b','b.company_branch_id = c.company_branch_id','left');
		$condition[] = array('join',TABLE_TRACKING_DETAILS.' as dt','dt.tracking_numbers_id = t.tracking_numbers_id','left');
		$condition[] = array('join',TABLE_DISPENSER_SALES.' as d','d.dispenser_sales_id = dt.dispenser_sales_id','left');
        $condition[] = array('where','t.is_status','Customer');

       	if ($access_branch!='') {
       		$acb =  explode(',',$access_branch);
            $condition[] = array('where_in','b.company_branch_id',$acb);
        }
        if ($customer_name!='') {
        	$condition[] = array('like','c.customer_name',$customer_name);
        	$this->page_data['customer_name_hidden']=$customer_name;
        }else{
        	$this->page_data['customer_name_hidden']='';
        }
        if ($dispenser_name!='') {
        	$condition[] = array('like','p.product_name',$dispenser_name);
        	$this->page_data['dispenser_name_hidden']=$dispenser_name;
        }else{
        	$this->page_data['dispenser_name_hidden']='';
        }
		
		

		$this->page_data['fields'] = array(
							'tracking_number' => 'Tracking Number',
							'customer_name' => 'Currently Possessed By',
							'installation_date' => 'First Transaction Date',
							'product_name' => 'Dispenser Name',
						);
        
		$sort_columns = array('t.tracking_number','c.customer_name','d.installation_date','p.product_name');
    
                              
		$selected_array=array(
                              'table_name'=>TABLE_TRACKING_NUMBERS.' as t',
                              'table_fields'=>'t.tracking_number,c.customer_name,c.customer_id, t.is_status,p.product_name,p.product_type, b.company_branch_name,dt.dispenser_sales_id,d.installation_date,d.dispenser_sales_id,d.product_id',
                              'group_by_field'=>'t.tracking_number',
                               'cond'=>$condition,
                               'order_by_field'=>'t.tracking_number',
								'order'=>'ASC',
                               'limit' => $limit,
								'offset' => $offset,
								'sort_by' => $sort_by,
								'sort_type' => $sort_type,
								'sort_order' => $sort_order,
								'sort_columns'=> $sort_columns,
								
                              );
		$results = $this->master_model->search($selected_array);
		$selected_array_data =array(
							'limit' =>'',
							'offset' =>'',
							'sort_by' => $sort_by,
							'sort_type' => $sort_type,
							'sort_order' => $sort_order,
							'sort_columns'=> $sort_columns,
							'table_fields'=>'t.tracking_number,c.customer_name, c.customer_id, t.is_status, p.product_name, p.product_type, b.company_branch_name,dt.dispenser_sales_id,d.installation_date,d.dispenser_sales_id,d.product_id',
							'group_by_field'=>'t.tracking_number',	
							'order_by_field'=>'t.tracking_number',
							'order'=>'ASC',					
							'table_name'=>TABLE_TRACKING_NUMBERS.' as t',
							'condition'=> $condition
							);
		$sale_data = $this->master_model->select_data($selected_array_data);
		$cnt_all_rows=count($sale_data);		
		if(!empty($results)&& is_array($sale_data))
		{
			$this->page_data['customer_report'] = $results['rows'];
			$this->page_data['num_results'] = $cnt_all_rows;
		}
		else
		{
			$results='';
		}	      
		$this->page_data['offset'] = $offset;
		/// pagination
		$this->load->library('pagination');
		$config = array();
		$config['base_url'] = site_url("gc/customer_tracking_reports/show_tracking/$query_id/$sort_by/$sort_order");
		$config['total_rows'] = $this->page_data['num_results'];
		$config['per_page'] = $limit;
		$config['uri_segment'] = 7;
		$config['full_tag_open'] = '<span class=\'paging\'>';
		$config['full_tag_close'] = '</span>';
		$config['first_link'] = 'First';
		$config['prev_link'] = '<<';
		$config['next_link'] = '>>';
		$config['last_link'] = 'Last';
		$this->pagination->initialize($config);
		
		$this->page_data['pagination'] = $this->pagination->create_links();
		$this->page_data['sort_by'] = $sort_by;
		$this->page_data['sort_order'] = $sort_order;
		$this->page_data['sort_type'] = $sort_type;
		$this->page_data['sort_columns'] = $sort_columns;
		$this->page_data['query_id'] = $query_id;
		$this->load->view('gc/customer_tracking_reports_list.php',$this->page_data);
			
	}
	function search_customer_report_tracking()
	{
		$query_array = array(
			
						'customer_name' =>check_injections_filter($this->input->post('customer_name')),
						'dispenser_name' =>check_injections_filter($this->input->post('dispenser_name')),
		
					);
		$this->load->library('NF_Query_search');
		$query_id = $this->nf_query_search->save_query($query_array);					
		redirect('gc/customer_tracking_reports/show_tracking/'.$query_id);		
	}
	function excel_data(){
		$customer_name = check_injections_filter($this->input->post('customer_excel_name'));
		$dispenser_name = check_injections_filter($this->input->post('dispenser_excel_name'));

		$access_branch= $this->session->userdata('access_branch');
		$condition = array();
		$condition[] = array('join',TABLE_CUSTOMER.' as c','c.customer_id = t.possessed_by','left');
		$condition[] = array('join',TABLE_PRODUCT.' as p','p.product_id = t.product_id','left');
		$condition[] = array('join',TABLE_COMPANY_BRANCH.' as b','b.company_branch_id = c.company_branch_id','left');
		$condition[] = array('join',TABLE_TRACKING_DETAILS.' as dt','dt.tracking_numbers_id = t.tracking_numbers_id','left');
		$condition[] = array('join',TABLE_DISPENSER_SALES.' as d','d.dispenser_sales_id = dt.dispenser_sales_id','left');
        $condition[] = array('where','t.is_status','Customer');

       	if ($access_branch!='') {
       		$acb =  explode(',',$access_branch);
            $condition[] = array('where_in','b.company_branch_id',$acb);
        }
        if ($customer_name!='') {
        	$condition[] = array('like','c.customer_name',$customer_name);
        	$this->page_data['customer_name_hidden']=$customer_name;
        }else{
        	$this->page_data['customer_name_hidden']='';
        }
        if ($dispenser_name!='') {
        	$condition[] = array('like','p.product_name',$dispenser_name);
        	$this->page_data['dispenser_name_hidden']=$dispenser_name;
        }else{
        	$this->page_data['dispenser_name_hidden']=$dispenser_name;
        }
        $selected_array_data = array(
                            'table_name'=>TABLE_TRACKING_NUMBERS.' as t',
                            'table_fields'=>'t.tracking_number,c.customer_name, c.customer_id, t.is_status, p.product_name, p.product_type, b.company_branch_name,dt.dispenser_sales_id,d.installation_date,d.dispenser_sales_id',
                            'condition'=>$condition,
                            'limit'=>'',
                            'order_by_field'=>'t.tracking_number',
                            'order'=>'ASC',
                            'group_by_field'=>'t.tracking_number',
                            'offset'=>''
                             );
		$excel_data['excel_data'] = $this->master_model->select_data($selected_array_data);
		if (!empty($excel_data['excel_data'])) {
		  $this->page_data['result_customer_report']=$excel_data['excel_data'];
		}else{
			$this->page_data['result_customer_report']='';
		}
		$this->load->view('gc/customer_tracking_reports_list_excel.php',$this->page_data);

	}
	

}
?>